package unipotsdam.informatikkiste;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import org.w3c.dom.Text;

/**
 * An activity, that displays a text and the given date-String as "date of last solve"
 */
public class DisplayAnswerActivity extends Activity implements View.OnClickListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState); //Remove title bar
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);

        //Remove notification bar
        this.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

        setContentView(R.layout.activity_display_answer);

        ((Button)findViewById(R.id.button_back)).setOnClickListener(this);
        ((RiddleIdView)findViewById(R.id.riddleIdView)).setTouchEnabled(false);
        ((RiddleIdView)findViewById(R.id.riddleIdView)).setBackgroundColor(getResources().getColor(R.color.colorSolved));

        Bundle data = getIntent().getExtras();
        if(data != null){
            ((RiddleIdView)findViewById(R.id.riddleIdView)).setRiddleId(data.getInt("riddleId"));
            ((TextView)findViewById(R.id.textView_LastSolve_text)).setText(data.getString("date"));
            ((TextView)findViewById(R.id.textView_message)).setText(data.getString("message"));
        }
    }

    @Override
    public void onClick(View v) {
        if(v.getId() == R.id.button_back){
            this.onBackPressed();
        }
    }
}
